module('g_highlights', package.seeall);

local highlight_list = {}
local next_id = 1

function reset()
    highlight_list = {}
    next_id = 1
end

function add(x,y,offset,radius,layer) --x,y,offset,radius,layer
    local id = next_id
    next_id = next_id + 1
    lua:create_circle( "uberduber_generic_shapename", 0.0,0.0, radius)                         --name, x, y, radius
    lua:create_trigger("uberduber_generic_trigger", TT_GATE, "data/scripts/srt_enter_highlight_zone.lua","data/scripts/srt_leave_highlight_zone.lua",x,y) --name, type, on_enter_script, on_leave_scipt,x,y
    lua:trigger_shape("uberduber_generic_trigger", TT_GATE, "uberduber_generic_shapename") --name, type, shape_name
    lua:trigger_add_group_i_belong_to("uberduber_generic_trigger", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me("uberduber_generic_trigger", TT_GATE, "player") --name, type, group_name
    lua:trigger_upload("uberduber_generic_trigger",id) --name
    
    highlight_list[id] = {x,y+offset,layer,nil}
end

function get_translation(id) --id
    return highlight_list[id]
end

function insert_gid(id,gid) --highlight id, gameobject id
    local tmp = highlight_list[id]
    tmp[4] = gid
end

function get_gid(id)
    local tmp = highlight_list[id]
    return tmp[4]
end